# SPDX-License-Identifier: GPL-2.0-only
# This file is part of Scapy RPC
# See https://scapy.net/ for more information
# Copyright (C) Gabriel Potter

# ms-samr.idl compiled on 06/07/2025
# This file is a stripped version ! Use scapy-rpc for the full.
"""
RPC definitions for the following interfaces:
- samr (v1.0): 12345778-1234-ABCD-EF00-0123456789AC
This file is auto-generated by midl-to-scapy, do not modify.
"""

import uuid


from scapy.layers.dcerpc import (
    NDRPacket,
    DceRpcOp,
    NDRConfPacketListField,
    NDRConfVarStrLenField,
    NDRConfVarStrLenFieldUtf16,
    NDRContextHandle,
    NDRFullEmbPointerField,
    NDRFullPointerField,
    NDRIntField,
    NDRPacketField,
    NDRShortField,
    register_dcerpc_interface,
)


class SamrConnect_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRShortField("ServerName", 0)),
        NDRIntField("DesiredAccess", 0),
    ]


class SamrConnect_Response(NDRPacket):
    fields_desc = [
        NDRPacketField("ServerHandle", NDRContextHandle(), NDRContextHandle),
        NDRIntField("status", 0),
    ]


class RPC_UNICODE_STRING(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRShortField("Length", None, size_of="Buffer", adjust=lambda _, x: (x * 2)),
        NDRShortField(
            "MaximumLength", None, size_of="Buffer", adjust=lambda _, x: (x * 2)
        ),
        NDRFullEmbPointerField(
            NDRConfVarStrLenFieldUtf16(
                "Buffer",
                "",
                size_is=lambda pkt: (pkt.MaximumLength // 2),
                length_is=lambda pkt: (pkt.Length // 2),
            )
        ),
    ]


class PSAMPR_RID_ENUMERATION(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("RelativeId", 0),
        NDRPacketField("Name", RPC_UNICODE_STRING(), RPC_UNICODE_STRING),
    ]


class PSAMPR_ENUMERATION_BUFFER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("EntriesRead", None, size_of="Buffer"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "Buffer",
                [PSAMPR_RID_ENUMERATION()],
                PSAMPR_RID_ENUMERATION,
                size_is=lambda pkt: pkt.EntriesRead,
            )
        ),
    ]


class SamrEnumerateDomainsInSamServer_Request(NDRPacket):
    fields_desc = [
        NDRPacketField("ServerHandle", NDRContextHandle(), NDRContextHandle),
        NDRIntField("EnumerationContext", 0),
        NDRIntField("PreferedMaximumLength", 0),
    ]


class SamrEnumerateDomainsInSamServer_Response(NDRPacket):
    fields_desc = [
        NDRIntField("EnumerationContext", 0),
        NDRFullPointerField(
            NDRPacketField(
                "Buffer", PSAMPR_ENUMERATION_BUFFER(), PSAMPR_ENUMERATION_BUFFER
            )
        ),
        NDRIntField("CountReturned", 0),
        NDRIntField("status", 0),
    ]


SAMR_OPNUMS = {
    0: DceRpcOp(SamrConnect_Request, SamrConnect_Response),
    # 4: Opnum4NotUsedOnWire,
    6: DceRpcOp(
        SamrEnumerateDomainsInSamServer_Request,
        SamrEnumerateDomainsInSamServer_Response,
    ),
    # 42: Opnum42NotUsedOnWire,
    # 43: Opnum43NotUsedOnWire,
    # 59: Opnum59NotUsedOnWire,
    # 60: Opnum60NotUsedOnWire,
    # 61: Opnum61NotUsedOnWire,
    # 63: Opnum63NotUsedOnWire,
    # 68: Opnum68NotUsedOnWire,
    # 69: Opnum69NotUsedOnWire,
    # 70: Opnum70NotUsedOnWire,
    # 71: Opnum71NotUsedOnWire,
    # 72: Opnum72NotUsedOnWire,
    # 75: Opnum75NotUsedOnWire,
    # 76: Opnum76NotUsedOnWire
}
register_dcerpc_interface(
    name="samr",
    uuid=uuid.UUID("12345778-1234-ABCD-EF00-0123456789AC"),
    version="1.0",
    opnums=SAMR_OPNUMS,
)
