#!/usr/bin/python3
"""
Pkgconf file handling for Fortran : tests

Copyright (C) 2025 Alastair McKinstry <mckinstry@debian.org>
Released under the GPL-3 Gnu Public License.
"""

from click.testing import CliRunner
import dhfortran.pkgconf as pk


def test_dh_fortran_pkgconf():
    runner = CliRunner()
    result = runner.invoke(pk.dh_fortran_pkgconf, [])
    assert result.exit_code == 0
    assert result.output == ""


def test_dh_fortran_pkgconf_verbose():
    runner = CliRunner()
    result = runner.invoke(pk.dh_fortran_pkgconf, ["--verbose"])
    assert result.exit_code == 0
    assert result.output.startswith("dh_fortran_pkgconf called with")


def test_dh_fortran_pkgconf_flavor():
    runner = CliRunner()
    result = runner.invoke(pk.dh_fortran_pkgconf, ["--flavor", "gfortran-15"])
    assert result.exit_code == 0
    assert result.output == ""


if __name__ == "__main__":
    import pytest

    pytest.main()
