/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright (C) 2018 - 2024 Intel Corporation */

#ifndef IPU6SE_PLATFORM_RESOURCES_H
#define IPU6SE_PLATFORM_RESOURCES_H

#include <linux/kernel.h>
#include <linux/device.h>
#include "ipu-platform-resources.h"

#define	IPU6SE_FW_PSYS_N_PADDING_UINT8_IN_PROCESS_EXT_STRUCT		1

enum {
	IPU6SE_FW_PSYS_CMD_QUEUE_COMMAND_ID = 0,
	IPU6SE_FW_PSYS_CMD_QUEUE_DEVICE_ID,
	IPU6SE_FW_PSYS_CMD_QUEUE_PPG0_COMMAND_ID,
	IPU6SE_FW_PSYS_CMD_QUEUE_PPG1_COMMAND_ID,
	IPU6SE_FW_PSYS_CMD_QUEUE_PPG2_COMMAND_ID,
	IPU6SE_FW_PSYS_CMD_QUEUE_PPG3_COMMAND_ID,
	IPU6SE_FW_PSYS_CMD_QUEUE_PPG4_COMMAND_ID,
	IPU6SE_FW_PSYS_CMD_QUEUE_PPG5_COMMAND_ID,
	IPU6SE_FW_PSYS_N_PSYS_CMD_QUEUE_ID
};

enum {
	IPU6SE_FW_PSYS_TRANSFER_VMEM0_TYPE_ID = 0,
	IPU6SE_FW_PSYS_LB_VMEM_TYPE_ID,
	IPU6SE_FW_PSYS_DMEM_TYPE_ID,
	IPU6SE_FW_PSYS_VMEM_TYPE_ID,
	IPU6SE_FW_PSYS_BAMEM_TYPE_ID,
	IPU6SE_FW_PSYS_PMEM_TYPE_ID,
	IPU6SE_FW_PSYS_N_MEM_TYPE_ID
};

enum ipu6se_mem_id {
	IPU6SE_FW_PSYS_TRANSFER_VMEM0_ID = 0,	/* TRANSFER VMEM 0 */
	IPU6SE_FW_PSYS_LB_VMEM_ID,	/* LB VMEM */
	IPU6SE_FW_PSYS_DMEM0_ID,	/* SPC0 Dmem */
	IPU6SE_FW_PSYS_DMEM1_ID,	/* SPP0 Dmem */
	IPU6SE_FW_PSYS_N_MEM_ID
};

enum {
	IPU6SE_FW_PSYS_DEV_CHN_DMA_EXT0_ID = 0,
	IPU6SE_FW_PSYS_DEV_CHN_DMA_EXT1_READ_ID,
	IPU6SE_FW_PSYS_DEV_CHN_DMA_EXT1_WRITE_ID,
	IPU6SE_FW_PSYS_DEV_CHN_DMA_ISA_ID,
	IPU6SE_FW_PSYS_N_DEV_CHN_ID
};

enum {
	IPU6SE_FW_PSYS_SP_CTRL_TYPE_ID = 0,
	IPU6SE_FW_PSYS_SP_SERVER_TYPE_ID,
	IPU6SE_FW_PSYS_ACC_ISA_TYPE_ID,
	IPU6SE_FW_PSYS_N_CELL_TYPE_ID
};

enum {
	IPU6SE_FW_PSYS_SP0_ID = 0,
	IPU6SE_FW_PSYS_ISA_ICA_ID,
	IPU6SE_FW_PSYS_ISA_LSC_ID,
	IPU6SE_FW_PSYS_ISA_DPC_ID,
	IPU6SE_FW_PSYS_ISA_B2B_ID,
	IPU6SE_FW_PSYS_ISA_BNLM_ID,
	IPU6SE_FW_PSYS_ISA_DM_ID,
	IPU6SE_FW_PSYS_ISA_R2I_SIE_ID,
	IPU6SE_FW_PSYS_ISA_R2I_DS_A_ID,
	IPU6SE_FW_PSYS_ISA_R2I_DS_B_ID,
	IPU6SE_FW_PSYS_ISA_AWB_ID,
	IPU6SE_FW_PSYS_ISA_AE_ID,
	IPU6SE_FW_PSYS_ISA_AF_ID,
	IPU6SE_FW_PSYS_ISA_PAF_ID,
	IPU6SE_FW_PSYS_N_CELL_ID
};

enum {
	IPU6SE_FW_PSYS_DEV_DFM_ISL_FULL_PORT_ID = 0,
	IPU6SE_FW_PSYS_DEV_DFM_ISL_EMPTY_PORT_ID,
};

/* Excluding PMEM */
#define IPU6SE_FW_PSYS_N_DATA_MEM_TYPE_ID (IPU6SE_FW_PSYS_N_MEM_TYPE_ID - 1)
#define IPU6SE_FW_PSYS_N_DEV_DFM_ID	\
	(IPU6SE_FW_PSYS_DEV_DFM_ISL_EMPTY_PORT_ID + 1)
#define IPU6SE_FW_PSYS_VMEM0_MAX_SIZE		0x0800
/* Transfer VMEM0 words, ref HAS Transfer*/
#define IPU6SE_FW_PSYS_TRANSFER_VMEM0_MAX_SIZE	0x0800
#define IPU6SE_FW_PSYS_LB_VMEM_MAX_SIZE		0x0400	/* LB VMEM words */
#define IPU6SE_FW_PSYS_DMEM0_MAX_SIZE		0x4000
#define IPU6SE_FW_PSYS_DMEM1_MAX_SIZE		0x1000

#define IPU6SE_FW_PSYS_DEV_CHN_DMA_EXT0_MAX_SIZE		22
#define IPU6SE_FW_PSYS_DEV_CHN_DMA_EXT1_READ_MAX_SIZE	22
#define IPU6SE_FW_PSYS_DEV_CHN_DMA_EXT1_WRITE_MAX_SIZE	22
#define IPU6SE_FW_PSYS_DEV_CHN_DMA_IPFD_MAX_SIZE		0
#define IPU6SE_FW_PSYS_DEV_CHN_DMA_ISA_MAX_SIZE		2

#define IPU6SE_FW_PSYS_DEV_DFM_ISL_FULL_PORT_ID_MAX_SIZE		32
#define IPU6SE_FW_PSYS_DEV_DFM_LB_FULL_PORT_ID_MAX_SIZE		32
#define IPU6SE_FW_PSYS_DEV_DFM_ISL_EMPTY_PORT_ID_MAX_SIZE		32
#define IPU6SE_FW_PSYS_DEV_DFM_LB_EMPTY_PORT_ID_MAX_SIZE		32

#endif /* IPU6SE_PLATFORM_RESOURCES_H */
