<!--
.. title: Security advisory: CVE-2018-12543
.. slug: security-advisory-cve-2018-12543
.. date: 2018-09-27 10:36:19 UTC+01:00
.. tags: Security,Releases
.. category:
.. link:
.. description:
.. type: text
-->

Mosquitto 1.5.3 has been released to address a security vulnerability. It also
includes other bug fixes.

# CVE-2018-12543

A vulnerability exists in Mosquitto versions 1.5 to 1.5.2 inclusive, known as
[CVE-2018-12543].

If a message received by the broker has a topic that begins with `$`, but that
does not begin `$SYS`, an assert is triggered that should otherwise not be
accessible, causing Mosquitto to exit.

The issue is fixed in Mosquitto 1.5.3. Patches for older versions are
available at <https://mosquitto.org/files/cve/2018-12543>

The fix addresses the problem by reverting a commit that intended to remove
some unused checks, but also stopped part of the topic hierarchy being created.

# Version 1.5.3 Changes

The complete list of fixes addressed in version 1.5.3 is:

## Security

* Fix [CVE-2018-12543]. If a message is sent to Mosquitto with a topic that
  begins with `$`, but is not `$SYS`, then an assert that should be unreachable
  is triggered and Mosquitto will exit.

## Broker
* Elevate log level to warning for situation when socket limit is hit.
* Remove requirement to use `user root` in snap package config files.
* Fix retained messages not sent by bridges on outgoing topics at the first
  connection. Closes [#701].
* Documentation fixes. Closes [#520], [#600].
* Fix duplicate clients being added to by_id hash before the old client was
  removed. Closes [#645].
* Fix Windows version not starting if `include_dir` did not contain any files.
  Closes [#566].

## Build
* Various fixes to ease building.

[CVE-2018-12543]: http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-12543
[#520]: https://github.com/eclipse/mosquitto/issues/520
[#566]: https://github.com/eclipse/mosquitto/issues/566
[#600]: https://github.com/eclipse/mosquitto/issues/600
[#645]: https://github.com/eclipse/mosquitto/issues/645
[#701]: https://github.com/eclipse/mosquitto/issues/701
