/*
 * Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package jdk.internal.ref;

import java.lang.ref.Cleaner;
import jdk.internal.ref.PhantomCleanable;
import jdk.internal.ref.CleanerImpl;
import jdk.internal.ref.CleanerImpl.CleanableList;

/**
 * This class provides package-private access to CleanableList internals.
 */
public class CleanableListTestHelper {

    public static final int NODE_CAPACITY = CleanableList.NODE_CAPACITY;

    final Cleaner cleaner;
    final CleanableList list;

    public CleanableListTestHelper() {
        cleaner = Cleaner.create();
        list = CleanerImpl.getCleanerImpl(cleaner).activeList;

        // List contains CleanerCleanable for Cleaner itself.
        // For testing empty list paths, we want to drop it.
        list.reset();
    }

    public TestCleanable newCleanable() {
        return new TestCleanable(cleaner);
    }

    public void insert(PhantomCleanable cl) {
        list.insert(cl);
    }

    public boolean remove(PhantomCleanable cl) {
        return list.remove(cl);
    }

    public boolean isEmpty() {
        return list.isEmpty();
    }

}
