# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from devtools_testutils.aio import recorded_by_proxy_async
from testpreparer import FaceSessionPreparer
from testpreparer_async import FaceSessionClientTestBaseAsync


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestFaceSessionAsync(FaceSessionClientTestBaseAsync):
    @FaceSessionPreparer()
    @recorded_by_proxy_async
    async def test_create_liveness_session(self, facesession_endpoint):
        client = self.create_async_client(endpoint=facesession_endpoint)
        response = await client.create_liveness_session(
            body={
                "livenessOperationMode": "str",
                "authTokenTimeToLiveInSeconds": 0,
                "deviceCorrelationId": "str",
                "deviceCorrelationIdSetInClient": bool,
                "enableSessionImage": bool,
                "livenessSingleModalModel": "str",
                "sendResultsToClient": bool,
            },
        )

        # please add some check logic here by yourself
        # ...

    @FaceSessionPreparer()
    @recorded_by_proxy_async
    async def test_delete_liveness_session(self, facesession_endpoint):
        client = self.create_async_client(endpoint=facesession_endpoint)
        response = await client.delete_liveness_session(
            session_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @FaceSessionPreparer()
    @recorded_by_proxy_async
    async def test_get_liveness_session_result(self, facesession_endpoint):
        client = self.create_async_client(endpoint=facesession_endpoint)
        response = await client.get_liveness_session_result(
            session_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @FaceSessionPreparer()
    @recorded_by_proxy_async
    async def test_get_liveness_sessions(self, facesession_endpoint):
        client = self.create_async_client(endpoint=facesession_endpoint)
        response = await client.get_liveness_sessions()

        # please add some check logic here by yourself
        # ...

    @FaceSessionPreparer()
    @recorded_by_proxy_async
    async def test_get_liveness_session_audit_entries(self, facesession_endpoint):
        client = self.create_async_client(endpoint=facesession_endpoint)
        response = await client.get_liveness_session_audit_entries(
            session_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @FaceSessionPreparer()
    @recorded_by_proxy_async
    async def test_delete_liveness_with_verify_session(self, facesession_endpoint):
        client = self.create_async_client(endpoint=facesession_endpoint)
        response = await client.delete_liveness_with_verify_session(
            session_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @FaceSessionPreparer()
    @recorded_by_proxy_async
    async def test_get_liveness_with_verify_session_result(self, facesession_endpoint):
        client = self.create_async_client(endpoint=facesession_endpoint)
        response = await client.get_liveness_with_verify_session_result(
            session_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @FaceSessionPreparer()
    @recorded_by_proxy_async
    async def test_get_liveness_with_verify_sessions(self, facesession_endpoint):
        client = self.create_async_client(endpoint=facesession_endpoint)
        response = await client.get_liveness_with_verify_sessions()

        # please add some check logic here by yourself
        # ...

    @FaceSessionPreparer()
    @recorded_by_proxy_async
    async def test_get_liveness_with_verify_session_audit_entries(self, facesession_endpoint):
        client = self.create_async_client(endpoint=facesession_endpoint)
        response = await client.get_liveness_with_verify_session_audit_entries(
            session_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @FaceSessionPreparer()
    @recorded_by_proxy_async
    async def test_detect_from_session_image(self, facesession_endpoint):
        client = self.create_async_client(endpoint=facesession_endpoint)
        response = await client.detect_from_session_image(
            body={"sessionImageId": "str"},
            session_image_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @FaceSessionPreparer()
    @recorded_by_proxy_async
    async def test_get_session_image(self, facesession_endpoint):
        client = self.create_async_client(endpoint=facesession_endpoint)
        response = await client.get_session_image(
            session_image_id="str",
        )

        # please add some check logic here by yourself
        # ...
