## TFSA-2018-001: BMP File Parser Out-of-bounds Read.

### CVE Number

CVE-2018-21233

### Issue Description

The BMP (bitmap image file graphics format) decoder had an out-of-bounds read
due to insufficient checking of header sizes and signed integer values. 

### Impact

The most likely consequence of this vulnerability would be that an invalid BMP
file could lead to an unhandled process crash, but may permit read access to
unintended regions of the TensorFlow process memory.

### Vulnerable Versions

TensorFlow 1.3.0, 1.3.1, 1.4.0, 1.4.1, 1.5.0, 1.5.1, 1.6.0

### Mitigation

We have patched the vulnerability in GitHub commit
[49f73c55](https://github.com/tensorflow/tensorflow/commit/49f73c55d56edffebde4bca4a407ad69c1cae433).
If users are running TensorFlow in production or on untrusted data, they are
encouraged to apply this patch.

Additionally, this patch has already been integrated into TensorFlow 1.7.0 and
newer.

### Credits

This issue was discovered by the Blade Team of Tencent.
