## TFSA-2022-066: Missing validation causes denial of service via `UnsortedSegmentJoin`

### CVE Number
CVE-2022-29197

### Impact
The implementation of [`tf.raw_ops.UnsortedSegmentJoin`](https://github.com/tensorflow/tensorflow/blob/f3b9bf4c3c0597563b289c0512e98d4ce81f886e/tensorflow/core/kernels/unsorted_segment_join_op.cc#L92-L95) does not fully validate the input arguments. This results in a `CHECK`-failure which can be used to trigger a denial of service attack:

```python
import tensorflow as tf

tf.raw_ops.UnsortedSegmentJoin(
  inputs=tf.constant("this", shape=[12], dtype=tf.string),
  segment_ids=tf.constant(0, shape=[12], dtype=tf.int64),
  num_segments=tf.constant(0, shape=[12], dtype=tf.int64))
```

The code assumes `num_segments` is a scalar but there is no validation for this before accessing its value:

```cc
const Tensor& num_segments_tensor = context->input(2);
OP_REQUIRES(context, num_segments_tensor.NumElements() != 0,
            errors::InvalidArgument("Number of segments cannot be empty."));
auto num_segments = num_segments_tensor.scalar<NUM_SEGMENTS_TYPE>()();
```

### Patches
We have patched the issue in GitHub commit [13d38a07ce9143e044aa737cfd7bb759d0e9b400](https://github.com/tensorflow/tensorflow/commit/13d38a07ce9143e044aa737cfd7bb759d0e9b400).

The fix will be included in TensorFlow 2.9.0. We will also cherrypick this commit on TensorFlow 2.8.1, TensorFlow 2.7.2, and TensorFlow 2.6.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Neophytos Christou from Secure Systems Lab at Brown University.
