/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef KEYBOARDUI_H
#define KEYBOARDUI_H

#include <QWidget>
#include <QHBoxLayout>
#include <QPushButton>

#include "settinggroup.h"
#include "titlelabel.h"
#include "switchwidget.h"
#include "sliderwidget.h"
#include "lineeditwidget.h"
#include "comboxwidget.h"
#include "pushbuttonwidget.h"

#define SMALLTEXTSIZE 24
#define MEDIUMTEXTSIZE 36
#define LARGETEXTSIZE 48

class KeyboardUi : public QWidget
{
    Q_OBJECT
public:
    explicit KeyboardUi(QWidget *parent = nullptr, Qt::WindowFlags f = Qt::WindowFlags());
    virtual ~KeyboardUi();

public:
    inline SwitchWidget *keyRepeatFrame()
    {
        return mKeyRepeatFrame;
    }

    inline SliderWidget *delayFrame()
    {
        return mDelayFrame;
    }

    inline SliderWidget *speedFrame()
    {
        return mSpeedFrame;
    }

    inline LineEditWidget *inputTestFrame()
    {
        return mInputTestFrame;
    }

    inline SwitchWidget *keyTipsFrame()
    {
        return mKeyTipsFrame;
    }

    inline PushButtonWidget *inputMethodFrame()
    {
        return mInputMethodSetFrame;
    }

    inline QPushButton *inputMethodPushButton()
    {
        return mInputMethodSetBtn;
    }

    inline SwitchWidget *showIconOnTrayFrame()
    {
        return mShowIconOnTrayFrame;
    }

    inline SwitchWidget *showIconOnDesktopFrame()
    {
        return mShowIconOnDesktopFrame;
    }

    inline SliderWidget *virtualKeyboardSizeFrame()
    {
        return mVirtualKeyboardSizeFrame;
    }

    inline ComboxWidget *textSizeFrame()
    {
        return mTextSizeFrame;
    }

    inline SwitchWidget *animationFrame()
    {
        return mAnimationFrame;
    }

    inline SwitchWidget *soundEfectsFrame()
    {
        return mSoundEfectsFrame;
    }

private:
    QVBoxLayout *mVlayout = nullptr;

    SettingGroup *mKeyboardFrame = nullptr;
    SettingGroup *mVirtualKeyboardFrame = nullptr;
    TitleLabel *mKeyboardSetTitleLabel = nullptr;
    TitleLabel *mVirtualKeyboardSetTitleLabel = nullptr;
    TitleLabel *mInputTitleLabel = nullptr;

    SwitchWidget *mKeyRepeatFrame = nullptr;            //按键重复
    SliderWidget *mDelayFrame = nullptr;                //延迟
    SliderWidget *mSpeedFrame = nullptr;                //速度
    LineEditWidget *mInputTestFrame = nullptr;          //输入测试
    SwitchWidget *mKeyTipsFrame = nullptr;              //按键提示
    SwitchWidget *mShowIconOnTrayFrame = nullptr;       // 在托盘显示虚拟键盘图标
    SwitchWidget *mShowIconOnDesktopFrame = nullptr;    // 在桌面显示虚拟键盘图标
    SliderWidget *mVirtualKeyboardSizeFrame = nullptr;  // 键盘大小
    ComboxWidget *mTextSizeFrame = nullptr;        // 按键文本大小
    SwitchWidget *mAnimationFrame = nullptr;            // 动画效果
    SwitchWidget *mSoundEfectsFrame = nullptr;          // 按键输入音效
    PushButtonWidget *mInputMethodSetFrame = nullptr;   //输入法设置
    QPushButton * mInputMethodSetBtn = nullptr;         // yangtze 输入法设置

private:
    void initUI();
    void setKeyRepeatFrame();
    void setDelayFrame();
    void setSpeedFrame();
    void setInputTestFrame();
    void setKeyTipsFrame();
    void setInputMethodFrame();

    void setShowIconOnTrayFrame();
    void setShowIconOnDesktopFrame();
    void setVirtualKeyboardSizeFrame();
    void setTextSizeFrame();
    void setAnimationFrame();
    void setSoundEfectsFrame();

};

#endif // KEYBOARDUI_H
