/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef NOTICEUI_H
#define NOTICEUI_H

#include <QObject>
#include <QWidget>
#include <QComboBox>

#include <shell/interface.h>
#include "titlelabel.h"
#include "lightlabel.h"
#include "kswitchbutton.h"
#include "switchwidget.h"
#include "settinggroup.h"

class NoticeUi : public QWidget
{
    Q_OBJECT
public:
    explicit NoticeUi(QWidget *parent = nullptr);
    void initUi();
    void initNotFaze(SettingGroup *widget);
    void initSearchText();

    KSwitchButton *getAutoOpenSwitchBtn() {return mAutoOpenSwitchBtn;}

    SwitchWidget *getNoticeWidget() {return mGetNoticeWidget;}
    SwitchWidget *getMultiScreenWidget() {return mMultiScreenWidget;}
    SwitchWidget *getAllowAlarmrWidget() {return mAllowAlarmrWidget;}
    SwitchWidget *getFullScreenWidget() {return mFullScreenWidget;}

    SettingGroup *getAppListWidget() {return mApplistWidget;}

    QComboBox *getOpenTimeHCombox() {return mOpenTimeHCombox;}
    QComboBox *getOpenTimeMCombox() {return mOpenTimeMCombox;}
    QComboBox *getCloseTimeHCombox() {return mCloseTimeHCombox;}
    QComboBox *getCloseTimeMCombox() {return mCloseTimeMCombox;}


private:
    TitleLabel *mNoticeLabel;
    TitleLabel *mNotFazeLabel;
    QLabel *mGetNoticeLabel;

    KSwitchButton *mAutoOpenSwitchBtn;

    SwitchWidget *mGetNoticeWidget;
    SwitchWidget *mMultiScreenWidget;
    SwitchWidget *mFullScreenWidget;
    SwitchWidget *mAllowAlarmrWidget;

    QComboBox *mOpenTimeHCombox;
    QComboBox *mOpenTimeMCombox;
    QComboBox *mCloseTimeHCombox;
    QComboBox *mCloseTimeMCombox;

    SettingGroup *mApplistWidget;
signals:

};

#endif // NOTICEUI_H
