/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef VINOINTERFACE_H
#define VINOINTERFACE_H

#include <QObject>
#include <QDBusArgument>
#include <QVariant>
#include <QDBusMetaType>
#include <QGSettings>
#include "universalinterface.h"

class VinoInterface : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.ukcc.session.Vino")
    Q_PROPERTY(bool isViewOnly READ getViewOnly)
    Q_PROPERTY(bool isPrompt READ getPromptEnabled)
    Q_PROPERTY(QString method READ getMethod)
    Q_PROPERTY(QString password READ getPassword)
    Q_PROPERTY(bool isActive READ getVinoServerStatus)
    Q_PROPERTY(bool isVino READ getVinoStatus)
    Q_PROPERTY(bool isXrdp READ getXrdpStatus)
    Q_PROPERTY(bool isEnable READ getEnableStatus)

public:
    VinoInterface();

protected:
    bool getViewOnly();
    bool getPromptEnabled();
    QString getMethod();
    QString getPassword();
    bool getVinoServerStatus();
    bool getVinoStatus();
    bool getXrdpStatus();
    bool getEnableStatus();

public Q_SLOTS:
    void setVinoKey(const QString &key, bool value);
    void setVinoKey(const QString &key, QString value);
    void setVinoKey(const QString &key, QByteArray value);

private:
    const QString kEnableKey =  "enabled";
    const QString kXrdpEnableKey = "xrdp-enabled";
    const QString kVinoEnableKey = "vino-enabled";
    const QString kVinoViewOnlyKey = "view-only";
    const QString kVinoPromptKey = "prompt-enabled";
    const QString kAuthenticationKey = "authentication-methods";
    const QString kVncPwdKey = "vnc-password";

    QGSettings *mVinoGsettings     = nullptr;
    QGSettings *mUkuiVinoGsettings = nullptr;
    QMap <QString, QString> mGsettingMap;
};

#endif // VINOINTERFACE_H
